﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO.IsolatedStorage;
using System.Xml.Linq;

namespace ShoppingList_Demo
{
    public partial class AddItem : PhoneApplicationPage
    {
        public AddItem()
        {
            InitializeComponent();
        }

        private void BtnSave_Click(object sender, RoutedEventArgs e)
        {
            using (IsolatedStorageFile storage = IsolatedStorageFile.GetUserStoreForApplication())
            {
                XDocument _doc = new XDocument();

                XElement _item = new XElement(nameTxt.Text);
                XAttribute price = new XAttribute("price", priceTxt.Text);
                XAttribute quantity = new XAttribute("quantity", quanTxt.Text);

                _item.Add(price, quantity);

                _doc = new XDocument(new XDeclaration("1.0", "utf-8", "yes"), _item);

                IsolatedStorageFileStream location = new IsolatedStorageFileStream(nameTxt.Text + ".item",
                        System.IO.FileMode.Create, storage);

                System.IO.StreamWriter file = new System.IO.StreamWriter(location);

                _doc.Save(file);

                file.Dispose();
                location.Dispose();

                NavigationService.Navigate(new Uri("/MainPage.xaml", UriKind.Relative));
            }
        }
    }
}