﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO.IsolatedStorage;
using System.Xml.Linq;
using System.Windows.Navigation;

namespace ShoppingList_Demo
{
    public partial class DisplayPage : PhoneApplicationPage
    {
        
        public DisplayPage()
        {
            InitializeComponent();
        }


        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            String itemName = "";

            base.OnNavigatedTo(e);

            bool itemExists = NavigationContext.QueryString.TryGetValue("item", out itemName);

            if (itemExists)
            {
                PageTitle.Text = itemName;
            }

            using (IsolatedStorageFile storage = IsolatedStorageFile.GetUserStoreForApplication())
            {
                XElement _xml;

                IsolatedStorageFileStream location = new IsolatedStorageFileStream(itemName, System.IO.FileMode.Open, storage);

                System.IO.StreamReader file = new System.IO.StreamReader(location);
                _xml = XElement.Parse(file.ReadToEnd());

                if (_xml.Name.LocalName != null)
                {
                    XAttribute priceTemp = _xml.Attribute("price");
                    priceTxt.Text = priceTemp.Value.ToLower();
                    XAttribute quanTemp = _xml.Attribute("quantity");
                    quanTxt.Text = quanTemp.Value.ToLower();
                    nameTxt.Text = itemName;
                }

                file.Dispose();
                location.Dispose();
            }
        }

        private void BtnBack_Click(object sender, RoutedEventArgs e)
        {
            NavigationService.Navigate(new Uri("/MainPage.xaml", UriKind.Relative));
        }
    }
}