﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO.IsolatedStorage;
using System.Xml.Linq;

namespace ShoppingList_Demo
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();

            Loaded += (object sender, RoutedEventArgs e) =>
            {
                Files.Items.Clear();
                using (IsolatedStorageFile storage = IsolatedStorageFile.GetUserStoreForApplication())
                {
                    foreach (string filename in storage.GetFileNames("*.item"))
                    {

                        Grid a = new Grid();

                        ColumnDefinition col = new ColumnDefinition();
                        GridLength gl = new GridLength(200);
                        col.Width = gl;
                        a.ColumnDefinitions.Add(col);

                        ColumnDefinition col2 = new ColumnDefinition();
                        GridLength gl2 = new GridLength(200);
                        col2.Width = gl;
                        a.ColumnDefinitions.Add(col2);

                        TextBlock txbx = new TextBlock();
                        txbx.Text = filename;
                        Grid.SetColumn(txbx, 0);

                        HyperlinkButton btn = new HyperlinkButton();
                        btn.Width = 100;
                        btn.Content = "Show";
                        btn.Name = filename;
                        btn.NavigateUri = new Uri("/DisplayPage.xaml?item=" + filename, UriKind.Relative);

                        Grid.SetColumn(btn, 1);
                        
                        a.Children.Add(txbx);
                        a.Children.Add(btn);

                        Files.Items.Add(a);

                    }
                }
            };

        }

        private void New_Click(object sender, EventArgs e)
        {
            NavigationService.Navigate(new Uri("/AddItem.xaml", UriKind.Relative));
        }
    }
}