﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Collections.ObjectModel;
using Olio.Model;

namespace Olio
{
    public partial class MainPage : PhoneApplicationPage
    {
        public ObservableCollection<OrderModel> orderlist;

        /*Constructor*/
        public MainPage()
        {
            InitializeComponent();
            orderlist = new ObservableCollection<OrderModel>();
        }   
         
        

        private void AddImg_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            //Go through Visual Tree and find quantity element
            int a = System.Convert.ToInt32(((TextBlock)((Grid)((Image)(sender)).Parent).Children[2]).Text);
            a += 1;

            //update quantity element
            ((TextBlock)((Grid)((Image)(sender)).Parent).Children[2]).Text = a.ToString();

            //Go through Visual Tree and find name elements
            string name = ((TextBlock)((Grid)((Image)(sender)).Parent).Children[0]).Text;

            //Based on name element to create final order list
            AddOrderList(name);    
        
        }

        private void AddOrderList(String name)
        {
            int flag = 0;

            foreach (OrderModel a in orderlist)
            {
                //Check whether item has been put into order list
                if (name.Equals(a.name))
                {
                    a.quantity += 1;
                    flag = 1;
                    break;
                }


            }

            //Add item into order list if hasnt been added before
            if (flag == 0)
            {
                orderlist.Add(new OrderModel(name, 1));
            }
        }

        private void SaveBtn_Click(object sender, RoutedEventArgs e)
        {
            //Save data into order.xml in Isolatedstroage
            App.IsolatedStorageCacheManager<ObservableCollection<OrderModel>>.Store("order.xml", orderlist);
            
            //Navigate to next page
            NavigationService.Navigate(new Uri("/OrderConfirm.xaml", UriKind.Relative));    
        
        }          
        
    }
}