﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Collections.ObjectModel;
using Olio.Model;
using Olio.ViewModel;
using Microsoft.Phone.Tasks;
using System.Windows.Media.Imaging;

namespace Olio
{
    public partial class OrderConfirm : PhoneApplicationPage
    {
        private ObservableCollection<OrderModel> OrderConfirmList;
        CameraCaptureTask cameraCaptureTask;

        public OrderConfirm()
        {
            InitializeComponent();
            //Retrieve order user places from IsolatedStroage
            OrderConfirmList = App.IsolatedStorageCacheManager<ObservableCollection<OrderModel>>.Retrieve("order.xml");

            //DataBind OrderList to OrderItems
            OrderList.DataContext = new OrderViewModel(OrderConfirmList);


            // Initialize the CameraCaptureTask and assign the Completed handler in the page constructor.
            cameraCaptureTask = new CameraCaptureTask();
            cameraCaptureTask.Completed += new EventHandler<PhotoResult>(cameraCaptureTask_Completed);
        

        }

        // The Completed event handler. In this example, a new BitmapImage is created and
        // the source is set to the result stream from the CameraCaptureTask
        void cameraCaptureTask_Completed(object sender, PhotoResult e)
        {
            if (e.TaskResult == TaskResult.OK)
            {
                BitmapImage bmp = new BitmapImage();
                bmp.SetSource(e.ChosenPhoto);
                image1.Source = bmp;
            }
        }
        
        private void PhotoBtn_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                cameraCaptureTask.Show();
            }
            catch (System.InvalidOperationException ex)
            {
                // Catch the exception, but no handling is necessary.
            }
        
        }

        private void OrderBtn_Click(object sender, RoutedEventArgs e)
        {
            //Create a web client for HTTP request/response
            var client = new WebClient();

            //Convert orderList into a String to send out
            string result = "";
            foreach (OrderModel a in OrderConfirmList)
            {
                result += a.name;
                result += " ";
                result += a.quantity;
                result += " ";
            }


            client.DownloadStringCompleted += (_, args) => MessageBox.Show(args.Result);
            client.DownloadStringAsync(new Uri("http://127.0.0.1:82/home/Echo/" + result));
        
        }
    }
}